/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.util;

import com.qiho.center.api.enums.AreaCodeEnum;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class IdCardUtil {
    private static String ILLEGAL_CHARACTER = "|{|}|#|$|'|\"|:|;|&|*|@|@|%|^|?";
    private static final char[] ILLEGAL_CHARACTER_ARR = new char[]{'{', '}', '#', '$', '{', '\'', '\"', ':', ';', '&', '*', '@', '@', '%', '^', '?'};

    public static boolean checkIdCardFormat(String idCard) {
        if (idCard == null || idCard.length() != 18) {
            return false;
        }
        boolean containsAny = StringUtils.containsAny((String)idCard, (char[])ILLEGAL_CHARACTER_ARR);
        if (containsAny) {
            return false;
        }
        boolean contains = AreaCodeEnum.CODES.contains(idCard.substring(0, 2));
        if (!contains) {
            return false;
        }
        return IdCardUtil.checkIdCard(idCard);
    }

    private static boolean checkIdCard(String idCard) {
        boolean flag;
        String[] idCardArray = idCard.split("");
        String ereg = Integer.parseInt(idCard.substring(6, 10)) % 4 == 0 || Integer.parseInt(idCard.substring(6, 10)) % 100 == 0 && Integer.parseInt(idCard.substring(6, 10)) % 4 == 0 ? "^[1-9][0-9]{5}(19|20)[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$" : "^[1-9][0-9]{5}(19|20)[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$";
        if (Pattern.matches(ereg, idCard)) {
            int s = (Integer.parseInt(idCardArray[0]) + Integer.parseInt(idCardArray[10])) * 7 + (Integer.parseInt(idCardArray[1]) + Integer.parseInt(idCardArray[11])) * 9 + (Integer.parseInt(idCardArray[2]) + Integer.parseInt(idCardArray[12])) * 10 + (Integer.parseInt(idCardArray[3]) + Integer.parseInt(idCardArray[13])) * 5 + (Integer.parseInt(idCardArray[4]) + Integer.parseInt(idCardArray[14])) * 8 + (Integer.parseInt(idCardArray[5]) + Integer.parseInt(idCardArray[15])) * 4 + (Integer.parseInt(idCardArray[6]) + Integer.parseInt(idCardArray[16])) * 2 + Integer.parseInt(idCardArray[7]) * 1 + Integer.parseInt(idCardArray[8]) * 6 + Integer.parseInt(idCardArray[9]) * 3;
            int y = s % 11;
            String m = "F";
            String jym = "10X98765432";
            m = jym.substring(y, y + 1);
            flag = m.equals(idCardArray[17]);
        } else {
            flag = false;
        }
        return flag;
    }

    public static void main(String[] args) {
        String idCard = "610632197407172015";
        System.out.println(IdCardUtil.checkIdCardFormat(idCard));
    }
}

