/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.order;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum OrderCancelReasonEnum {
    TAKE_FOR_FREE("\u4ee5\u4e3a\u514d\u8d39"),
    HAVE_CONTACTED_MERCHANT("\u5df2\u4e0e\u5176\u4ed6\u5546\u5bb6\u53d6\u5f97\u8054\u7cfb"),
    NOT_MY_ORDER("\u975e\u672c\u4eba\u4e0b\u5355"),
    GIRL("\u5973\u6027"),
    STUDENT("\u5b66\u751f"),
    LINE_NOT_CONNECTED("\u7535\u8bdd\u672a\u63a5\u901a");

    private final String cancelReason;

    private OrderCancelReasonEnum(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public static List<String> listCancelReason() {
        return Stream.of(OrderCancelReasonEnum.values()).map(OrderCancelReasonEnum::getCancelReason).collect(Collectors.toList());
    }

    public static boolean isllegal(String reason) {
        if (StringUtils.isBlank((CharSequence)reason)) {
            return false;
        }
        return Stream.of(OrderCancelReasonEnum.values()).map(OrderCancelReasonEnum::getCancelReason).anyMatch(reason::equals);
    }
}

