package com.qiho.center.api.enums.logistics;

/**
 * 描述：记录物流是通过哪个平台的哪个接口调用上传的
 *
 * @author zhouziwu
 * @date 2022-03-07
 */
public enum LogisticsSourceEnum {
    /** 平台：百奇商家后台管理系统 */
    BAIQI_MERCHANT_BACKEND(1, "百奇商家后台"),

    /** 平台：推啊百奇后台管理系统 */
    BAIQI_MANAGER_BACKEND(3, "推啊百奇后台"),

    /** 平台：给外部调用的接口API M9，qiho-manager：com.qiho.manager.deploy.controller.open.OpenOrderController */
    BAIQI_OPEN_ORDER_BACKEND(5, "API M9"),

    /** 接口入口：百奇商家后台-全部订单-批量更新订单状态 */
    MERCHANT_BATCH_PROCESS_ORDER(11, "百奇商家后台-全部订单-批量更新订单状态"),

    /** 接口入口：百奇商家后台-全部订单、待付款订单、已取消订单、待发货订单模块-上传物流单号 */
    MERCHANT_ORDER_CONFIRM(12, "百奇商家后台-单条上传物流单号"),

    /** 接口入口：百奇商家后台-全部订单、待付款订单、已取消订单、待发货订单模块-更新物流 */
    MERCHANT_ORDER_UPDATE(13, "百奇商家后台-单条更新物流单号"),

    /** 接口入口：百奇商家后台-待付款订单、已取消订单、待发货订单模块-批量上传物流单号 */
    MERCHANT_BATCH_ORDER_CONFIRM(14, "百奇商家后台-待付款、已取消、待发货模块批量上传物流单号"),

    /** 接口入口：百奇商家后台-已发货订单-批量更新物流 */
    MERCHANT_BATCH_ORDER_UPDATE(15, "百奇商家后台-已发货订单-批量更新物流"),

    MERCHANT_OPEN_BATCH_RESOLVE_ORDER(16, "百奇商家后台-/deliveryOrder/resolveErpOrder"),

    /** 接口入口：百奇管理后台-订单-全部订单-上传物流单号 */
    MANAGER_ORDER_CONFIRM(31, "推啊百奇后台-订单-全部订单-上传物流单号"),

    /** 接口入口：百奇管理后台-订单-全部订单-更新物流 */
    MANAGER_ORDER_UPDATE(32, "推啊百奇后台-订单-全部订单-更新物流"),

    /** 接口入口：百奇管理后台-订单-全部订单-批量物流操作-批量确认发货 */
    MANAGER_BATCH_ORDER_CONFIRM(33, "推啊百奇后台-订单-全部订单-批量物流操作-批量确认发货"),

    /** 接口入口：百奇管理后台-订单-全部订单-批量物流操作-批量更新物流 */
    MANAGER_BATCH_ORDER_UPDATE(34, "推啊百奇后台-订单-全部订单-批量物流操作-批量更新物流"),

    /** 接口入口：百奇管理后台-订单-全部订单-批量物流操作-批量更新订单状态 */
    MANAGER_BATCH_PROCESS_ORDER(35, "推啊百奇后台-订单-全部订单-批量物流操作-批量更新订单状态"),

    OPEN_BATCH_RESOLVE_ORDER(51, "推啊百奇后台-/openOrder/batchResolveOrder"),

    OPEN_BATCH_UPDATE_ORDER(52, "推啊百奇后台-/openOrder/batchUpdateOrder"),

    OPEN_RESOLVE_ERP_ORDER(53, "推啊百奇后台-/openOrder/resolveErpOrder"),

    OPEN_UPDATE_ERP_ORDER(54, "推啊百奇后台-/openOrder/updateErpOrder"),

    OPEN_UPDATE_ORDER_STATUS(55, "推啊百奇后台-/openOrder/updateOrderStatus"),

    OPEN_BATCH_UPDATE_ORDER_STATUS(56, "推啊百奇后台-/openOrder/batch/updateOrderStatus"),
    ;

    private Integer num;
    private String name;
    LogisticsSourceEnum(Integer num, String name) {
        this.num = num;
        this.name = name;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
