package com.qiho.center.api.enums.ordertmpauto;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum UploadTypeEnum {

    IN_PROCESS(1, "处理中"),
    SUCCESS(2, "全部成功"),
    FAIL(3, "全部失败"),
    PARTIAL_SUCCESS(4, "部分成功")
    ;

    private final Integer code;

    private final String desc;

    UploadTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UploadTypeEnum fromCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (UploadTypeEnum typeEnum : UploadTypeEnum.values()) {
            if (Objects.equals(typeEnum.getCode(), code)) {
                return typeEnum;
            }
        }
        return null;
    }
}
