package com.qiho.center.api.util;

import com.qiho.center.api.constant.ChuangLanConstant;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;

/**
 * 下单短信的工具类
 * @author chensong
 * @create 2018-05-18 17:13
 **/
public class OrderSmsUtil {

    private OrderSmsUtil(){

    }

    /**
     * 创蓝的返回码映射成百奇的返回码
     * @param status
     * @return
     */
    public static SmsMobileStatusEnum getReturnCodeByChuangLanStatus(String status){
        SmsMobileStatusEnum baiqiCode ;
        if(status.equals("ERRNUM")||status.equals("SGIP:1")||status.equals("MN:0001")
                ||status.equals("MK:0001")||status.equals("CB:0001")||status.equals("6640")
                ||status.equals("0006")||status.equals("XL:169")||status.equals("1")||
                status.equals("10")||status.equals("67")||status.equals("61")||status.equals("72")||
                status.equals("101")||status.equals("-1")||status.equals("RP:1")||
                status.equals("Deliver")||status.equals("LT:0001")){
            baiqiCode = SmsMobileStatusEnum.EMPTY_NUM;
        }else if(status.equals("MBBLACK")){
            baiqiCode = SmsMobileStatusEnum.BLACKLIST;
        }else if(status.startsWith("MK")||status.startsWith("MI")||status.startsWith("MN")||
                status.startsWith("SGIP")||status.startsWith("UNDELIV")||status.startsWith("CU")||
                status.startsWith("RP:")||
                status.equals("0005")||status.equals("IB:0064")||status.equals("4") ||status.equals("54")||
                status.equals("51")||status.equals("-37")||status.equals("53")||
                status.equals("4716")||status.equals("0007")||status.equals("5")||status.equals("50")||
                status.equals("45")||status.equals("36")||status.equals("56") ||status.equals("213")||
                status.equals("ID:0102")||status.equals("SPMSERR:102")){
            baiqiCode = SmsMobileStatusEnum.CLOSE_DOWN;
        }else if(status.equals("DELIVRD")){
            baiqiCode = SmsMobileStatusEnum.SUCCESS;
        }else {
            baiqiCode = SmsMobileStatusEnum.UNKNOWN;
        }
        return baiqiCode;
    }


    /**
     * 获取百奇状态
     *
     * @param status
     * @return
     */
    public static SmsMobileStatusEnum getReturnCodeByMonternetStatus(String status,String errorCode){

        if("0".equals(status)){
            return SmsMobileStatusEnum.SUCCESS;
        }

        SmsMobileStatusEnum baiqiCode ;

        if ("R:00005".equals(errorCode) ||
            "R:00012".equals(errorCode) ||
            "R:00029".equals(errorCode) ||
            "R:00023".equals(errorCode) ||
            "R:00033".equals(errorCode) ||
            "MI:0013".equals(errorCode) ||
            "MN:0001".equals(errorCode) ||
            "Err_Num".equals(errorCode) ||
            "R:00660".equals(errorCode) ||
            "R:04414".equals(errorCode) ||
            "R:04701".equals(errorCode) ||
            "MN:0020".equals(errorCode) ||
            "MN:0051".equals(errorCode) ||
            "R:00008".equals(errorCode) ||
            "".equals(errorCode)) {
            baiqiCode = SmsMobileStatusEnum.EMPTY_NUM;
        } else if ("M2:0045".equals(errorCode) ||
            "M1:0045".equals(errorCode) ||
            "DB:0141".equals(errorCode) ||
            "DB00141".equals(errorCode) ||
            "DB:0144".equals(errorCode) ||
            "R1:1011".equals(errorCode)
            ) {
            baiqiCode = SmsMobileStatusEnum.BLACKLIST;
        } else if (
            "R:00255".equals(errorCode) ||
            "R:00011".equals(errorCode) ||
            "R:00010".equals(errorCode) ||
            "R:00001".equals(errorCode) ||
            "R:00093".equals(errorCode) ||
            "R:00013".equals(errorCode) ||
            "R:00213".equals(errorCode) ||
            "R:00980".equals(errorCode) ||
            "R:00124".equals(errorCode) ||
            "R:00101".equals(errorCode) ||
            "R:00068".equals(errorCode) ||
            "IC:0055".equals(errorCode) ||
            "MC:0055".equals(errorCode) ||
            "MI:0029".equals(errorCode) ||
            "MK:0001".equals(errorCode) ||
            "MI:0024".equals(errorCode) ||
            "IC:0151".equals(errorCode) ||
            "R:00602".equals(errorCode) ||
            "EXPIRED".equals(errorCode) ||
            "IC:0015".equals(errorCode) ||
            "R:04442".equals(errorCode) ||
            "MC:0151".equals(errorCode) ||
            "MI:0000".equals(errorCode) ||
            "MI:0001".equals(errorCode) ||
            "MI:0002".equals(errorCode) ||
            "MI:0004".equals(errorCode) ||
            "MI:0005".equals(errorCode) ||
            "MI:0008".equals(errorCode) ||
            "MI:0011".equals(errorCode) ||
            "MI:0012".equals(errorCode) ||
            "MI:0015".equals(errorCode) ||
            "MI:0017".equals(errorCode) ||
            "MI:0020".equals(errorCode) ||
            "MI:0022".equals(errorCode) ||
            "MI:0030".equals(errorCode) ||
            "MI:0036".equals(errorCode) ||
            "MI:0044".equals(errorCode) ||
            "MI:0045".equals(errorCode) ||
            "MI:0050".equals(errorCode) ||
            "MI:0051".equals(errorCode) ||
            "MI:0053".equals(errorCode) ||
            "MI:0054".equals(errorCode) ||
            "MI:0056".equals(errorCode) ||
            "MI:0057".equals(errorCode) ||
            "MI:0059".equals(errorCode) ||
            "MI:0063".equals(errorCode) ||
            "MI:0064".equals(errorCode) ||
            "MI:0068".equals(errorCode) ||
            "MI:0075".equals(errorCode) ||
            "MI:0080".equals(errorCode) ||
            "MI:0081".equals(errorCode) ||
            "MI:0083".equals(errorCode) ||
            "MI:0084".equals(errorCode) ||
            "MI:0098".equals(errorCode) ||
            "MK:0008".equals(errorCode) ||
            "MK:0010".equals(errorCode) ||
            "MK:0011".equals(errorCode) ||
            "MK:0012".equals(errorCode) ||
            "MK:0015".equals(errorCode) ||
            "MK:0020".equals(errorCode) ||
            "MK:0022".equals(errorCode) ||
            "MK:0024".equals(errorCode) ||
            "MK:0044".equals(errorCode) ||
            "MK:0045".equals(errorCode) ||
            "MK:0055".equals(errorCode) ||
            "MK:0066".equals(errorCode) ||
            "MK:0115".equals(errorCode) ||
            "MK:0150".equals(errorCode) ||
            "MN:0011".equals(errorCode) ||
            "MN:0012".equals(errorCode) ||
            "MN:0017".equals(errorCode) ||
            "MN:0022".equals(errorCode) ||
            "MN:0029".equals(errorCode) ||
            "MN:0036".equals(errorCode) ||
            "MN:0044".equals(errorCode) ||
            "MN:0053".equals(errorCode) ||
            "MN:0054".equals(errorCode) ||
            "MN:0059".equals(errorCode) ||
            "MN:0075".equals(errorCode) ||
            "MN:0090".equals(errorCode) ||
            "R1:0013".equals(errorCode) ||
            "R1:0043".equals(errorCode) ||
            "R:00002".equals(errorCode) ||
            "R:00003".equals(errorCode) ||
            "R:00004".equals(errorCode) ||
            "R:00009".equals(errorCode) ||
            "R:00014".equals(errorCode) ||
            "R:00015".equals(errorCode) ||
            "R:00017".equals(errorCode) ||
            "R:00019".equals(errorCode) ||
            "R:00020".equals(errorCode) ||
            "R:00022".equals(errorCode) ||
            "R:00027".equals(errorCode) ||
            "R:00035".equals(errorCode) ||
            "R:00041".equals(errorCode) ||
            "R:00044".equals(errorCode) ||
            "R:00045".equals(errorCode) ||
            "R:00048".equals(errorCode) ||
            "R:00050".equals(errorCode) ||
            "R:00051".equals(errorCode) ||
            "R:00053".equals(errorCode) ||
            "R:00054".equals(errorCode) ||
            "R:00055".equals(errorCode) ||
            "R:00056".equals(errorCode) ||
            "R:00057".equals(errorCode) ||
            "R:00058".equals(errorCode) ||
            "R:00059".equals(errorCode) ||
            "R:00064".equals(errorCode) ||
            "R:00067".equals(errorCode) ||
            "R:00069".equals(errorCode) ||
            "R:00070".equals(errorCode) ||
            "R:00072".equals(errorCode) ||
            "R:00073".equals(errorCode) ||
            "R:00075".equals(errorCode) ||
            "R:00079".equals(errorCode) ||
            "R:00083".equals(errorCode) ||
            "R:00085".equals(errorCode) ||
            "R:00086".equals(errorCode) ||
            "R:00088".equals(errorCode) ||
            "R:00089".equals(errorCode) ||
            "R:00090".equals(errorCode) ||
            "R:00092".equals(errorCode) ||
            "R:00096".equals(errorCode) ||
            "R:00098".equals(errorCode) ||
            "R:00099".equals(errorCode) ||
            "R:00106".equals(errorCode) ||
            "R:00181".equals(errorCode) ||
            "R:00210".equals(errorCode) ||
            "R:00230".equals(errorCode) ||
            "R:00245".equals(errorCode) ||
            "R:00253".equals(errorCode) ||
            "R:00254".equals(errorCode) ||
            "R:00605".equals(errorCode) ||
            "R:00612".equals(errorCode) ||
            "R:00613".equals(errorCode) ||
            "R:00614".equals(errorCode) ||
            "R:00615".equals(errorCode) ||
            "R:00617".equals(errorCode) ||
            "R:00619".equals(errorCode) ||
            "R:00627".equals(errorCode) ||
            "R:00634".equals(errorCode) ||
            "R:00636".equals(errorCode) ||
            "R:00640".equals(errorCode) ||
            "R:00650".equals(errorCode) ||
            "R:00680".equals(errorCode) ||
            "R:00701".equals(errorCode) ||
            "R:00702".equals(errorCode) ||
            "R:00704".equals(errorCode) ||
            "R:00706".equals(errorCode) ||
            "R:00708".equals(errorCode) ||
            "R:00711".equals(errorCode) ||
            "R:00713".equals(errorCode) ||
            "R:00714".equals(errorCode) ||
            "R:00718".equals(errorCode) ||
            "R:00721".equals(errorCode) ||
            "R:00726".equals(errorCode) ||
            "R:00760".equals(errorCode) ||
            "R:00761".equals(errorCode) ||
            "R:00762".equals(errorCode) ||
            "R:00763".equals(errorCode) ||
            "R:00764".equals(errorCode) ||
            "R:00765".equals(errorCode) ||
            "R:00771".equals(errorCode) ||
            "R:00779".equals(errorCode) ||
            "R:00801".equals(errorCode) ||
            "R:00802".equals(errorCode) ||
            "R:00814".equals(errorCode) ||
            "R:00815".equals(errorCode) ||
            "R:00817".equals(errorCode) ||
            "R:00827".equals(errorCode) ||
            "R:00875".equals(errorCode) ||
            "R:00899".equals(errorCode) ||
            "R:00999".equals(errorCode) ||
            "REJECTD".equals(errorCode) ||
            "UNDELIV".equals(errorCode) ||
            "R:00219".equals(errorCode) ||
            "MK:0029".equals(errorCode) ||
            "R:00000".equals(errorCode) ||
            "R:04300".equals(errorCode) ||
            "R:00705".equals(errorCode)
        ) {
            baiqiCode = SmsMobileStatusEnum.CLOSE_DOWN;
        } else {
            baiqiCode = SmsMobileStatusEnum.UNKNOWN;
        }
        return baiqiCode;
    }

}
