package com.qiho.center.api.dto.security.param;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/20 3:22 下午
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class SecurityFundApproveParam implements Serializable {

    private static final long serialVersionUID = 321209396617425489L;

    private Long id;

    /**
     * 审批类型 {@link com.qiho.center.api.enums.security.SecurityFundApproveTypeEnum}
     */
    private Integer approveType;

    /**
     * 拒绝理由
     */
    private String processorComment;

    /**
     * 操作人
     */
    private Long operatorId;

    /**
     * 是否有财务助理审批权限
     */
    private Boolean financeAssistantPower;

    /**
     * 是否有财务主管审批权限
     */
    private Boolean financeManagerPower;
}
