package com.qiho.center.api.enums.page;

import lombok.Getter;

import java.util.Arrays;

/**
 * js对接平台
 *
 * @author peanut.huang
 * @date 2020/6/2
 * @since JDK 1.8
 */
@Getter
public enum JSPlatformEnum {

    /**
     *
     */
    BAI_QI(1, "百奇"),

    VIVO(2, "vivo"),

    OPPO(3, "OPPO"),

    KUAISHOU(4, "快手"),

    KUAISHOU_API(5, "快手-API上报"),

    JULIANG_API(6, "巨量-API上报")

    ;

    private final int type;
    private final String desc;

    JSPlatformEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据类型查询
     *
     * @param type
     * @return
     */
    public static JSPlatformEnum findByType(int type){
        return Arrays.stream(JSPlatformEnum.values()).filter(e -> e.getType() == type).findFirst().orElse(null);
    }

}
