/**
 * Project Name:qiho-center-api
 * File Name:RemoteTemplateService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年6月21日上午9:30:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.TemplateDto;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.params.template.TemplateParams;

/**
 * ClassName:RemoteTemplateService <br/>
 * 模板dubb服务. <br/>
 * Date:     2017年6月21日 上午9:30:02 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteTemplateService {

    /**
     * 模板开关
     * @author zhanglihui
     * @param id     模板ID
     * @param enable 是否开启
     * @return DubboResult
     */
    DubboResult<Void> enableSwitch(Long id, Boolean enable);
    
    /**
     * 新增模板
     *
     * @author zhanglihui
     * @param templateParams  短信模板相关信息
     * @return DubboResult
     */
    DubboResult<Void> addTemplate(TemplateParams templateParams);
    
    /**
     * 更新模板内容
     *
     * @author zhanglihui
     * @param params
     * @return DubboResult
     */
    DubboResult<Void> updateTemplate(TemplateParams params);
    
    /**
     * 查询模板列表
     *
     * @author zhanglihui
     * @return List<TemplateDto>
     */
    DubboResult<List<TemplateDto>> findTemplateList();

    /**
     * 根据模板代码查询模板内容
     *
     * @author zhanglihui
     * @param templateCode
     * @return 模板内容
     */
    TemplateDto findByCode(String templateCode);

    /**
     * 模糊搜索短信模板信息
     *
     * @param templateParams 短信模板参数
     * @return
     */
    List<TemplateDto> findTemplateByParam(TemplateParams templateParams);

    /**
     * 根据模板ID获取短信模板代码
     *
     * @param id 模板ID
     * @return
     */
    String getTemplateCodeById(Long id);

    /**
     * 删除模版
     *
     * @param id
     * @return
     */
    boolean deleteTemplate(Long id);
}

