package com.qiho.center.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.AccountAgentMerchantRelationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.params.account.AccountAgentMerchantPageParam;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2020/7/18 7:04 下午
 */
@AdvancedFeignClient
public interface RemoteAccountAgentMerchantRelationService {

    /**
     * 批量插入(同时sql层面支持触发唯一索引更新的机制)
     *
     * @param merchantRelationDtos
     * @return
     */
    int batchInsert(List<AccountAgentMerchantRelationDto> merchantRelationDtos);

    /**
     * 根据账号ID和关联类型查询关联对象
     *
     * @param accountId
     * @param relationType
     * @return
     */
    List<AccountAgentMerchantRelationDto> findRelationEntityByAccountId(Long accountId, Integer relationType);

    /**
     * 根据账号ID和关联类型查询关联对象
     *
     * @param accountAgentMerchantPageParam
     * @return
     */
    PagenationDto<MerchantDto> findMerchantIdByAccountId(AccountAgentMerchantPageParam accountAgentMerchantPageParam);

    /**
     * 根据账号ID和关联类型查询关联对象
     *
     * @param accountId
     * @param relationType
     * @return
     */
    AccountAgentMerchantRelationDto findRelationEntityByAccountIdAndRelationId(Long accountId, Long relationId, Integer relationType);

    /**
     * 根据关联的ID 批量查询关联信息
     *
     * @param relatedIds
     * @return
     */
    List<AccountAgentMerchantRelationDto> findDtoByRelatedIds(List<Long> relatedIds);

    /**
     * 根据账号ID 批量查询关联信息
     *
     * @param accountIds
     * @return
     */
    List<AccountAgentMerchantRelationDto> findDtoByAccountIds(List<Long> accountIds);
}
