/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.component;

import com.qiho.center.api.enums.component.ComponentBaseTypeEnum;
import com.qiho.center.api.enums.component.ComponentUsageTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentTypeEnum {
    ITEM_DETAIL(3, "ITEM_DETAIL", "\u5546\u54c1\u8be6\u60c5", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    ORDER_FORM(1, "ORDER_FORM", "\u8868\u5355\u7ec4\u4ef6", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    ORDER_BUTTON(2, "ORDER_BUTTON", "\u4e0b\u5355\u6309\u94ae", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),
    OBTAIN_RECORD(4, "OBTAIN_RECORD", "\u9886\u53d6\u8bb0\u5f55", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    CUSTOMIZE_COMPONENT(5, "CUSTOMIZE_COMPONENT", "\u81ea\u5b9a\u4e49\u7ec4\u4ef6", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    MARQUEE(6, "MARQUEE", "\u8dd1\u9a6c\u706f", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    ITEM_EVALUATE(7, "ITEM_EVALUATE", "\u5546\u54c1\u8bc4\u8bba", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    POP_LAYER(8, "POP_LAYER", "\u5f39\u7a97", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    BUOY(9, "BUOY", "\u6d6e\u6807", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
    ITEM_LIST(10, "ITEM_LIST", "\u5546\u54c1\u5217\u8868", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    BANNER(11, "BANNER", "\u8f6e\u64ad\u56fe", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    WAIST_SEAL(12, "WAIST_SEAL", "\u56fe\u7247", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COLLECTION_BUOY(13, "COLLECTION_BUOY", "\u6d6e\u6807", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    SHOW_ADVERT(14, "SHOW_ADVERT", "\u5c55\u793a\u5e7f\u544a", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COLLECTION_MARQUEE(15, "COLLECTION_MARQUEE", "\u8dd1\u9a6c\u706f", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),
    COUNT_DOWN(16, "COUNT_DOWN", "\u5012\u8ba1\u65f6", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE);

    private String code;
    private String desc;
    private Integer num;
    private Boolean required;
    private ComponentBaseTypeEnum baseType;
    private ComponentUsageTypeEnum usageType;

    private ComponentTypeEnum(Integer num, String code, String desc, Boolean required, ComponentBaseTypeEnum baseType, ComponentUsageTypeEnum usageType) {
        this.code = code;
        this.desc = desc;
        this.num = num;
        this.required = required;
        this.baseType = baseType;
        this.usageType = usageType;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getNum() {
        return this.num;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ComponentBaseTypeEnum getBaseType() {
        return this.baseType;
    }

    public ComponentUsageTypeEnum getUsageType() {
        return this.usageType;
    }

    public static ComponentTypeEnum getByNum(Integer num) {
        if (num == null) {
            return null;
        }
        return ((Stream)Stream.of(ComponentTypeEnum.values()).parallel()).filter(e -> e.getNum().equals(num)).findFirst().orElse(null);
    }

    public static List<ComponentTypeEnum> fetchNecessaryComponent(ComponentUsageTypeEnum usageType) {
        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values()).filter(e -> e.getUsageType().equals((Object)usageType) && e.getRequired() != false).collect(Collectors.toList());
        return list;
    }

    public static List<ComponentTypeEnum> getByUsageType(ComponentUsageTypeEnum usageType) {
        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values()).filter(e -> e.getUsageType().equals((Object)usageType)).collect(Collectors.toList());
        return list;
    }
}

