package com.qiho.center.api.dto.ordertmp;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;

import java.util.Date;

/** 临时订单Dto
 * @author chensong
 * @create 2018-05-09 17:31
 **/
public class OrderTmpDto extends BaseDto {

    /** id */
    private Long id;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    /** 订单编号 */
    private String  orderId;

    /** 商品id */
    private Long itemId;

    /** 商品名称 */
    private String  itemName;

    /** 商品货号 */
    private String  itemNo;

    /** 商品编码 */
    private String  skuNo;

    /** 收件人姓名 */
    private String  consumerName;

    /** 收件人电话 */
    private String  mobile;

    /** 发货方式 */
    private String  delivery;

    private DeliveryEnum deliveryEnum;

    private OrderTmpStatusEnum orderStatusEnum;

    /** 结算渠道id */
    private String  channelId;

    /** 统计渠道id */
    private String  countChannelId;

    /** 商家id */
    private Long merchantId;

    /** 行政区代码 */
    private String areaNum;

    /** 临时订单的状态 1-待过滤 2-无效 */
    private Integer orderStatus;

    /** 订单普通风控校验的结果，1-业务校验不通过，2-黑名单不通过，3-过滤规则不通过 */
    private Integer riskCheck;

    /** 备注信息:当订单无效时的不通过原因 */
    private String remark;

    public DeliveryEnum getDeliveryEnum() {
        return deliveryEnum;
    }

    public void setDeliveryEnum(DeliveryEnum deliveryEnum) {
        this.deliveryEnum = deliveryEnum;
    }

    public OrderTmpStatusEnum getOrderStatusEnum() {
        return orderStatusEnum;
    }

    public void setOrderStatusEnum(OrderTmpStatusEnum orderStatusEnum) {
        this.orderStatusEnum = orderStatusEnum;
    }

    public String getAreaNum() {
        return areaNum;
    }

    public void setAreaNum(String areaNum) {
        this.areaNum = areaNum;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemNo() {
        return itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public String getSkuNo() {
        return skuNo;
    }

    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    public String getConsumerName() {
        return consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getDelivery() {
        return delivery;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getCountChannelId() {
        return countChannelId;
    }

    public void setCountChannelId(String countChannelId) {
        this.countChannelId = countChannelId;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getRiskCheck() {
        return riskCheck;
    }

    public void setRiskCheck(Integer riskCheck) {
        this.riskCheck = riskCheck;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
