package com.qiho.center.api.enums;

/**
 * @author Wangpf
 * @description  用户上传文件 批量取消/审核订单  文件错误枚举
 * @date 2019/12/20 11:07 AM
 */
public enum TaskFailMsgEnum {

    /**
     * 审核不通过）正确格式为:订单ID；审核状态；不通过原因
     *
     * 审核状态标准格式为：通过、不通过
     *
     * 审核状态为「通过」，不通过原因可忽略；
     *
     * 审核状态为「不通过」，不通过原因为必填
     *
     * （取消发货）标题格式错误，正确格式：订单ID；取消订单原因（必填）
     */
    ERROR_STYLE("格式错误"),

    /**
     * 订单号、审核状态、相关原因缺失
     */
    NOT_ENOUGH_INFORMATION("信息错误或缺失"),

    /**
     * 审核不通过）仅“待审核”状态订单可操作「审核不通过」，其他状态均不能操作
     *
     *（取消发货）仅“待发货”状态订单可操作「取消发货」，其他状态均不能操作
     */
    ERROR_ORDER_STATE("订单状态错误"),

    REPEAT_ORDER_ID("订单ID重复"),

    ;

    private final String failMsg;


    TaskFailMsgEnum(String failMsg) {
        this.failMsg = failMsg;
    }

    public String getFailMsg() {
        return failMsg;
    }
}
