package com.qiho.center.api.params.menu;

import java.io.Serializable;
import java.util.Objects;

/**
 * 菜单查询参数
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:16
 */
public class MenuParams implements Serializable {

    /**
     * 父菜单ID
     */
    private Long parentId;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 菜单备注
     */
    private String remark;

    /**
     * 菜单排序序号
     */
    private Integer sorted;

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode;
    }

    public String getMenuName() {
        return menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getSorted() {
        return sorted;
    }

    public void setSorted(Integer sorted) {
        this.sorted = sorted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        MenuParams params = (MenuParams) o;
        return Objects.equals(parentId, params.parentId) && Objects.equals(menuCode, params.menuCode) && Objects
            .equals(menuName, params.menuName) && Objects.equals(remark, params.remark) && Objects
            .equals(sorted, params.sorted);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parentId, menuCode, menuName, remark, sorted);
    }

    @Override
    public String toString() {
        return "MenuParams{" + "parentId=" + parentId + ", menuCode='" + menuCode + '\'' + ", menuName='" + menuName
            + '\'' + ", remark='" + remark + '\'' + ", sorted=" + sorted + '}';
    }
}
