package com.qiho.center.api.remoteservice.blackList;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.dto.blackList.BlacklistCheckDto;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.BlackListCheckParams;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.BlackStrategyParams;

/**
 * ClassName: RemoteBlackListService <br/>
 * Function: 黑名单管理. <br/>
 * date: 2017年6月20日 下午5:07:47 <br/>
 *
 * @author chencheng
 * @version
 */
@AdvancedFeignClient
public interface RemoteBlackListService {

    /**
     * 查询黑名单总数
     * 
     * @param params
     * @return 
     */
    DubboResult<Integer> findBlackListCount(BlackListParams params);

    /**
     * 分页查询黑名单订单
     *
     * @author chencheng
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return
     */
    DubboResult<PagenationDto<BlackListDto>> queryBlackListPage(BlackListParams params);

    /**
     * 批量黑名单处理
     * 
     * @param progressKey 审核进度查询Key,用于向缓存中写进度,调用batchAuditOrderInit获取
     * @param paramList
     * @return 处理黑名单条数
     */
    DubboResult<Integer> batchBlackList(String progressKey, List<BlackListOperationParams> paramList);

    /**
     * 删除黑名单
     *
     * @author chencheng
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(Long id, QueryBlackListTypeEnum type);

    /**
     * 查询黑名单策略
     *
     * @author chencheng
     * @param strategyType
     * @return
     */
    DubboResult<OrderStrategyDto> findBlackStrategy(StrategyType strategyType);

    /**
     * 配置黑名单策略
     *
     * @author chencheng
     * @param blackListStrategyDto
     * @return
     */
    DubboResult<Integer> updateBlackStrategy(BlackStrategyParams params);

    /**
     * 黑名单校验接口
     */
    DubboResult<BlacklistCheckDto> blackListCheck(BlackListCheckParams params);

}
