package com.qiho.center.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;


/**
 * 消息远程调用接口(管理后台)
 * @author: wangjin
 * @create 2018-07-02 14:51
 **/
@AdvancedFeignClient
public interface RemoteMessageBackendService {


    /**
     * 新增或修改
     * @param dto
     * @return
     */
    boolean saveMessage(MessageNotifyDto dto);

    /**
     * 保存并发布
     * @param dto
     * @return
     */
    boolean saveAndPublishMessage(MessageNotifyDto dto);

    /**
     * 消息列表
     * @param params
     * @return
     */
    PagenationDto<MessageNotifyDto> findMessages(MessageNotifyPagingParams params);

    /**
     * 查看消息详情
     * @param id 消息id
     * @return
     */
    MessageNotifyDto findMessageById(Long id);

    /**
     * 删除
     * @param id 消息id
     * @return
     */
    boolean deleteMessage(Long id);
}
