package com.qiho.center.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;

import java.util.List;

/**
 *  百奇页面后台服务
 *
 * @author peanut.huang
 * @date 2018/2/23.
 */
@AdvancedFeignClient
public interface RemotePageBackendService {

    /**
     * 分页查询页面
     *
     * @param pageName    页面名称
     * @param pageTypes    页面类型
     * @param offset      偏移量
     * @param pageSize    每页条数
     * @return
     */
    PagenationDto<BaiqiPageDto> find4Paging(String pageName, List<Integer> pageTypes, Integer offset, Integer pageSize);

    /**
     * 保存百奇页面
     *
     *   当pageDto 中id不为null ： update
     *   当pageDto 中id为null ： insert
     *
     * @param pageDto     页面实体
     * @return            页面id
     */
    Long savePage(BaiqiPageDto pageDto);

    /**
     * 根据页面id获取页面文件md5
     *
     * <p>用以判断页面文件代码是否更新</p>
     *
     * @param pageId   页面id
     * @return         页面文件md5值
     */
    String findPageMd5(Long pageId);

    /**
     * 根据页面id查询页面信息
     *
     * @param pageId  页面id
     * @return        页面信息
     */
    BaiqiPageDto findById(Long pageId);

    /**
     * 查询最小pid值
     *
     * @param pageType
     * @return Long
     */
    Long findMinPid(Integer pageType);
}
