package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 快递100订单状态对应库中状态
 */
public enum KuaiDi100OrderStatusEnum {

	/**
     * 接单
     */
    ACCEPT("ACCEPT","1","接单"),

    /** 在途 */
    UNDER_WAY("UNDER_WAY", "0", "在途"),

    /** 签收失败 */
    FAILED("FAILED", "2", "签收失败"),
	/**
	 * 派件
     */
    SENT_SCAN("SENT_SCAN", "5", "派件"),

    /** 签收成功 */
    SUCCESS("SUCCESS", "3", "签收成功"),

    /** 退件成功 */
    RETURN("RETURN", "4", "退件成功"),

    /**退回中*/
    SEND_BACK("SEND_BACK","6", "退回中"),

    /** 拒签 */
    REJECTED("REJECTED", "14", "拒签"),

    /**签收异常*/
    ABNORMAL("ABNORMAL","15", "签收异常");

    /** 代码 */
    private String status;

    private String kuaiDi100Status;

    /** 描述 */
    private String desc;

    KuaiDi100OrderStatusEnum(String status, String kuaiDi100Status, String desc) {
        this.status = status;
        this.kuaiDi100Status = kuaiDi100Status;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param kuaiDi100State
     * @return DatabaseSchema
     */
    public static KuaiDi100OrderStatusEnum getByKuaiDi100Status(String kuaiDi100State) {
        // 如果是 快递100物流状态是 [7-转投],  物流子订单为 [0-在途]
        if (StringUtils.equals(KuaiDi100LogisticsOrderStatusEnum.TRANSIT.getState(), kuaiDi100State)) {
            return KuaiDi100OrderStatusEnum.UNDER_WAY;
        }
        // 如果是 快递100物流状态是 [2-疑难],  物流子订单为 [15-ABNORMAL]
        if (StringUtils.equals(KuaiDi100LogisticsOrderStatusEnum.PUZZLE.getState(), kuaiDi100State)) {
            return KuaiDi100OrderStatusEnum.ABNORMAL;
        }
        for (KuaiDi100OrderStatusEnum enumVal : KuaiDi100OrderStatusEnum.values()) {
            if (StringUtils.equals(kuaiDi100State, enumVal.getKuaiDi100Status())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public String getKuaiDi100Status() {
        return kuaiDi100Status;
    }

    public String getDesc() {
        return desc;
    }
}

