package com.qiho.center.api.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-06-01
 */
public enum PopupWindowDeletedFailEnum {
    /**
     * 删除弹窗失败返回值对应的失败原因
     */
    IDS_IS_NULL(-1, "参数错误"),
    DATA_IS_NULL(-2, "查询结果为空"),
    POPUP_WINDOW_STATUS_ON(-3, "该弹窗为开启状态，无法删除。");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    private PopupWindowDeletedFailEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取枚举值
     *
     * @param code
     * @return
     */
    public static PopupWindowDeletedFailEnum getByCode(Integer code) {
        for (PopupWindowDeletedFailEnum enumVal : PopupWindowDeletedFailEnum.values()) {
            if (code.intValue() == enumVal.getCode().intValue()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 获取所有code的集合
     *
     * @param
     * @return
     */
    public static List<Integer> getCodeList() {
        List<Integer> codeList = new ArrayList<>();
        for (PopupWindowDeletedFailEnum enumVal : PopupWindowDeletedFailEnum.values()) {
            codeList.add(enumVal.code);
        }
        return codeList;
    }

    /**
     * @return code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
