package com.qiho.center.api.params.sms;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Wangpf
 * @description 接收移动梦网推送消息
 * @date 2020/4/29 11:18 AM
 */
public class MonternetReceiveParam {

    /**
     * 用户Id
     */
    private String userid;

    /**
     * 密码
     */
    private String pwd;

    /**
     * 时间戳 MMDDHHMMSS
     */
    private String timestamp;

    /**
     * 推送上行请求命令
     */
    private String cmd;

    /**
     * 请求消息流水号
     */
    private String seqid;

    /**
     * 上行信息 {@link Rpt}
     */
    private String rpts;


    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getSeqid() {
        return seqid;
    }

    public void setSeqid(String seqid) {
        this.seqid = seqid;
    }

    public String getRpts() {
        return rpts;
    }

    public void setRpts(String rpts) {
        this.rpts = rpts;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("userid", userid)
            .append("pwd", pwd)
            .append("timestamp", timestamp)
            .append("cmd", cmd)
            .append("seqid", seqid)
            .append("rpts", rpts)
            .toString();
    }
}
