package com.qiho.center.api.enums.rediskey;

/**
 * @author Wangpf
 * @description 根据文件上传批量取消和审核所用redis相关key
 * @date 2019/12/20 4:52 PM
 */
public enum TaskRedisKeyEnum {

    /**
     * 通用redis key
     */
    TASK_KEY("status","handelCount","totalCount","success","failLines");

    /**
     * 任务状态
     */
    private final String status;

    /**
     * 成功处理的总数量
     */
    private final String handelCount;

    /**
     * 总数量
     */
    private final String totalCount;

    /**
     * 是否成功
     */
    private final String success;

    /**
     * 错误的行数
     */
    private final String failLines;

    TaskRedisKeyEnum(String status,String handelCount,String totalCount,String success,
        String failLines) {
        this.status = status;
        this.handelCount = handelCount;
        this.totalCount = totalCount;
        this.success = success;
        this.failLines = failLines;
    }

    public String getStatus() {
        return status;
    }

    public String getHandelCount() {
        return handelCount;
    }

    public String getTotalCount() {
        return totalCount;
    }

    public String getSuccess() {
        return success;
    }

    public String getFailLines() {
        return failLines;
    }
}
