package com.qiho.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by weny.cai on 2017/11/29.
 * 奇货系统标准的快递公司枚举
 * 系统内部使用
 */
public enum QihoExpressEnum {

    YTO("YTO","圆通速递"),
    BEST_EX("BEST_EX","百世汇通"),
    JD("JD","京东快递"),
    ZTO("ZTO","中通快递"),
    STO("STO","申通快递"),
    YD("YD","韵达快递"),
    SF("SF","顺丰快递"),
    DBL("DBL","德邦物流");

    private String code;
    private String name;

    QihoExpressEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    private static Map<String, QihoExpressEnum> enumMap     = Maps.newHashMap();
    private static Map<String, QihoExpressEnum> nameEnumMap = Maps.newHashMap();
    static {
        for (QihoExpressEnum it : QihoExpressEnum.values()) {
            enumMap.put(it.code, it);
            nameEnumMap.put(it.name, it);
        }
    }

    /**
     * getNameByCode:根据编码获取公司名称. <br/>
     * @param code
     * @return DatabaseSchema
     */
    public static QihoExpressEnum getByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * getByCode:根据公司名称获取编码. <br/>
     * @param name
     * @return DatabaseSchema
     */
    public static QihoExpressEnum getByName(String name) {
        return nameEnumMap.get(name);
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
