package com.qiho.center.api.enums;

/**
 * Created by danke on 2017/6/16.
 * 用于返回结果异常的枚举类
 */
public enum ResultErrorEnum {

    PARAMS_ERROR(10001,"参数非法"),

    SERVICE_ERROR(10002,"接口异常"),

    RESULT_ERROR(10003,"接口调用返回值异常"),

    RESULT_NULL(10004,"接口调用返回值null");

    int code;
    String message;

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }


    public static ResultErrorEnum getByCode(Integer code) {
        if (code==null) {
            return null;
        }
        for (ResultErrorEnum teacherTypeEnum : ResultErrorEnum.values()) {
            if (teacherTypeEnum.getCode() == code) {
                return teacherTypeEnum;
            }
        }
        return null;
    }


    ResultErrorEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }
}
