package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/9/21.
 * 短信渠道类型枚举
 */
public enum  SmsTypeEnum {

    YUNPIAN(1, "YUNPIAN", "云片", false),
    YUNZHIXUN(2, "YUNZHIXUN", "云之讯", false),
    MEI_LIAN(3, "MEILIAN", "美联", false),
    CHUANG_LAN(4, "CHUANGLAN", "创蓝", true),
    MONTERNET(5, "MONTERNET", "移动梦网", true),
    YUN_TREE(6,"YUNTREE","云之树",false),

    /**
     * 中台短信验证码服务 只用来在百奇后台发送短信验证码
     */
    CENTRAL_PLATFORM_CODE(7,"CENTRAL_PLATFORM_CODE","中台短信验证码",false)
    ;

    private int num;

    private String code;

    private String msg;

    /** 是否需要接收运营商的推送报告 */
    private boolean needReport;


    SmsTypeEnum(int num, String code, String msg, boolean needReport) {
        this.num = num;
        this.code = code;
        this.msg = msg;
        this.needReport = needReport;
    }

    /**
     * 通过val值去获取对应的枚举
     * @param code
     */
    public static SmsTypeEnum fromCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for (SmsTypeEnum smsTypeEnum : SmsTypeEnum.values()) {
            if (smsTypeEnum.getCode().equals(code)) {
                return smsTypeEnum;
            }
        }
        return null;
    }

    public static SmsTypeEnum fromNum(int num){
        for (SmsTypeEnum smsTypeEnum : SmsTypeEnum.values()) {
            if (smsTypeEnum.getNum() == num) {
                return smsTypeEnum;
            }
        }
        return null;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isNeedReport() {
        return needReport;
    }
}
