package com.qiho.center.api.dto;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 带统计对象的分页结果对象
 * @author chensong
 * @create 2018-08-13
 */
public class StatisticsPagenationDto<T extends Serializable, R extends Serializable> implements Serializable {

    private static final long serialVersionUID = -1224434332028757751L;

    /** 分页数据 */
    private List<T> list = Collections.emptyList();

    /** 统计中暑 */
    private Integer total  = 0;

    /** 统计对象 */
    private R statistics;

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public R getStatistics() {
        return statistics;
    }

    public void setStatistics(R statistics) {
        this.statistics = statistics;
    }

    /**
     * 返回一个空的分页结果
     * @return
     */
    public StatisticsPagenationDto<T, R> emptyPage(){
        this.setTotal(0);
        this.setList(Lists.newArrayList());
        this.setStatistics(null);
        return this;
    }


}
