package com.qiho.center.api.enums.log;

/**
 * @author Wangpf
 * @description 订单相关枚举类——> 涉及订单签收 拒签 出单的节点
 * @date 2020/5/12 2:12 下午
 */
public enum OrderLogSubTypeEnum {

    /**
     * 订单正常签收
     */
    RECEIVED(9,"签收"),

    /**
     * 订单拒签
     */
    REFUSE(10, "拒签"),

    /**
     * 新增物流子订单-> 出单
     */
    ADD_LOGISTICS_ORDER(11,"出单"),

    /**
     * 取消订单
     */
    CANCEL_ORDER(12,"取消订单"),

    /**
     * 核单失败
     */
    AUDIT_FAIL(13,"核单失败"),

    /**
     * 核单成功
     */
    AUDIT_PASS(14,"核单成功")
    ;


    /**
     *  订单日志类型 9-签收/10-拒签
     */
    private final int subType;

    /**
     * 日志类型描述
     */
    private final String desc;

    OrderLogSubTypeEnum(int subType, String desc) {
        this.subType = subType;
        this.desc = desc;
    }

    public int getSubType() {
        return subType;
    }

    public String getDesc() {
        return desc;
    }
}
