package com.qiho.center.api.enums.log;

/**
 * @author Wangpf
 * @description 出单类型 1-上传,2-更新
 * @date 2020/5/12 3:34 下午
 */
public enum PostPrintTypeEnum {

    UPLOAD(1,"上传"),

    UPDATE(2,"更新")

    ;

    /**
     *  订单日志类型 1-上传,2-更新
     */
    private final int postPrintType;

    /**
     * 出单类型描述
     */
    private final String desc;

    PostPrintTypeEnum(int postPrintType, String desc) {
        this.postPrintType = postPrintType;
        this.desc = desc;
    }

    public int getPostPrintType() {
        return postPrintType;
    }

    public String getDesc() {
        return desc;
    }
}
