package com.qiho.center.api.util;

import com.alibaba.fastjson.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/10/19.
 * 简单的json工具,用于处理扩展字段
 */
public class JSONUtil {
    private JSONUtil() {
    }

    public static <T> List<T> parseJSONStrToList(String key, String metaValue, Class<T> clazz) {
        Assert.notNull(clazz, "转换类型不能为空");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(metaValue))
            return new ArrayList<>();
        JSONObject extJson = JSONObject.parseObject(metaValue);
        String stageStr = extJson.getString(key);
        if (StringUtils.isNotBlank(stageStr)) {
            return JSONObject.parseArray(stageStr, clazz);
        }
        return new ArrayList<>();
    }

    /**
     * 可能返回null
     *
     * @param key
     * @param metaValue
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T parseJSONStrToObject(String key, String metaValue, Class<T> clazz) {
        Assert.notNull(clazz, "转换类型不能为空");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(metaValue))
            return null;
        JSONObject extJson = JSONObject.parseObject(metaValue);
        String stageStr = extJson.getString(key);
        if (StringUtils.isNotBlank(stageStr)) {
            return JSONObject.parseObject(stageStr, clazz);
        }
        return null;
    }

    /**
     * String字符串转换为JSONObject对象 <br>
     * <p>
     *
     * @param str JSON格式的字符串
     */
    public static JSONObject strToJSON(String str) {
        str = StringUtils.isBlank(str) ? null : str.replaceAll(" ", "");
        if (StringUtils.isNotBlank(str) && isJSON(str)) {
            return JSONObject.parseObject(str);
        }
        return null;
    }

    /**
     * JSONObject对象转换为String字符串 <br>
     * <p>
     *
     * @param jsonStr JSONObject对象
     */
    public static String JSONToStr(JSONObject jsonStr) {
        return JSONUtils.isNull(jsonStr) ? "" : jsonStr.toString();
    }

    /**
     * 判断String字符串是否为JSON格式
     *
     * @param str
     * @return
     */
    private static Boolean isJSON(String str) {
        try {
            JSONObject.parseObject(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

}
