/**
 * Project Name:qiho-center-api
 * File Name:ErpTypeEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日上午11:40:59
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.enums;

/**
 * @Description  全局配置Key枚举类
 * @Date 15:10 2020-07-14
 * @Param
 * @return
 **/
public enum OverallConfigEnum {

    //定制下单结果页
    BAIQI_CUSTOMIZE_APPS(0, "BAIQI_CUSTOMIZE_APPS"),

    //大字报媒体key
    BIG_MEDIA_KEY(1, "BIG_MEDIA_KEY"),

    //加粉媒体Key
    JF_MEDIA_KEY(2, "JF_MEDIA_KEY"),

    //自动取消黑名单key
    AUTO_CANCEL_BLACK(3, "AUTO_CANCEL_BLACK_KEY"),

    //自动取消时间key
    AUTO_CANCEL_TIME(4, "AUTO_CANCEL_TIME_KEY");


    /** 代码 */
    private Integer code;

    /** 描述 */
    private String desc;

    private OverallConfigEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static OverallConfigEnum getByCode(Integer code) {
        for (OverallConfigEnum enumVal : OverallConfigEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     *
     * @return code
     */
    public Integer getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

