package com.qiho.center.api.enums.component;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/** 组件类型
 * @author chensong
 * @create 2018-07-24
 */
public enum ComponentTypeEnum {


    /**  商品详情页组件类型  start  */

//    OBTAIN_RECORD(4, "OBTAIN_RECORD", "领取记录", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
////
////    MARQUEE(6, "MARQUEE", "跑马灯", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
////
////    ITEM_EVALUATE(7, "ITEM_EVALUATE", "商品评论", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
////
////    POP_LAYER(8, "POP_LAYER", "弹窗", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),
////
////    BUOY(9, "BUOY", "浮标", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),

    ORDER_FORM(1, "ORDER_FORM", "表单", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),

    ORDER_BUTTON(2, "ORDER_BUTTON", "按钮", true, ComponentBaseTypeEnum.ITEM_BASIC, ComponentUsageTypeEnum.ITEM_DEATIL),

    ITEM_DETAIL(3, "ITEM_DETAIL", "商品详情", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),

    SLIDE_SHOW(5, "SLIDE_SHOW", "轮播图", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),

    VIDEO(50, "VIDEO", "视频", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),

    SALE_COMPONENT(51, "SALE_COMPONENT", "营销组件", false, ComponentBaseTypeEnum.ITEM_ATMOSPHERE, ComponentUsageTypeEnum.ITEM_DEATIL),

    /**  商品详情页组件类型  end  */







    /**  集合页组件类型  start */

    ITEM_LIST(10, "ITEM_LIST", "商品列表", false, null,  ComponentUsageTypeEnum.COLLECTION_PAGE),

    BANNER(11, "BANNER", "轮播图", false, null,  ComponentUsageTypeEnum.COLLECTION_PAGE),

    // 因需求要求，描述由 "腰封" 更名为 "图片"
    WAIST_SEAL(12, "WAIST_SEAL", "图片", false, null,  ComponentUsageTypeEnum.COLLECTION_PAGE),

    COLLECTION_BUOY(13, "COLLECTION_BUOY", "浮标", false, null,  ComponentUsageTypeEnum.COLLECTION_PAGE),

    SHOW_ADVERT(14, "SHOW_ADVERT", "展示广告", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),

    COLLECTION_MARQUEE(15, "COLLECTION_MARQUEE", "跑马灯", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE),

    COUNT_DOWN(16, "COUNT_DOWN", "倒计时", false, null, ComponentUsageTypeEnum.COLLECTION_PAGE);

    /**  集合页组件类型  end */





    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 数字类型 */
    private Integer num;

    /** 是否必须 */
    private Boolean required;

    /** 基本类型  */
    private ComponentBaseTypeEnum baseType;

    /** 适用类型 */
    private ComponentUsageTypeEnum usageType;

    private ComponentTypeEnum(Integer num, String code, String desc, Boolean required, ComponentBaseTypeEnum baseType, ComponentUsageTypeEnum usageType){
        this.code = code;
        this.desc = desc;
        this.num = num;
        this.required = required;
        this.baseType = baseType;
        this.usageType = usageType;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public Boolean getRequired() {
        return required;
    }

    public ComponentBaseTypeEnum getBaseType() {
        return baseType;
    }

    public ComponentUsageTypeEnum getUsageType() {
        return usageType;
    }

    /**
     * 根据数值获取
     * @param num
     * @return
     */
    public static ComponentTypeEnum getByNum(Integer num){
        if (num == null) {
            return null;
        }

        return Stream.of(ComponentTypeEnum.values()).parallel()
                .filter(e -> e.getNum().equals(num)).findFirst().orElse(null);
    }

    /**
     * 获取必选的组件类型
     * @param usageType 组件的适用类型
     * @return
     */
    public static List<ComponentTypeEnum> fetchNecessaryComponent(ComponentUsageTypeEnum usageType){

        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values())
                .filter(e ->
                    e.getUsageType().equals(usageType) && e.getRequired()
                ).collect(Collectors.toList());

        return list;
    }


    /**
     * 根据组件的适用类型查找
     * @param usageType
     * @return
     */
    public static List<ComponentTypeEnum> getByUsageType(ComponentUsageTypeEnum usageType){

        List<ComponentTypeEnum> list = Stream.of(ComponentTypeEnum.values())

                .filter(e -> e.getUsageType().equals(usageType)).collect(Collectors.toList());

        return list;
    }





}
