package com.qiho.center.api.enums.item;

import java.util.Objects;

/**
 * 商品评论等级
 *
 * @author zhangbaiqiang
 * @date 2020/8/13
 */
public enum ItemEvaluateLevelEnum {

    POSITIVE(1, "好评"),
    NEGATIVE(2, "差评");

    private Integer type;
    private String desc;

    ItemEvaluateLevelEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        if (Objects.equals(type, POSITIVE.type)) {
            return POSITIVE.desc;
        } else if (Objects.equals(type, NEGATIVE.type)) {
            return NEGATIVE.desc;
        } else {
            return null;
        }
    }

    public static Integer getTypeByDesc(String desc) {
        if (Objects.equals(desc, POSITIVE.desc)) {
            return POSITIVE.type;
        } else if (Objects.equals(desc, NEGATIVE.desc)) {
            return NEGATIVE.type;
        } else {
            return null;
        }
    }
}
