package com.qiho.center.api.enums.finance;

import java.util.stream.Stream;

/**
 * Created by xianhongwei on 2017/12/22.
 */
public enum FinanceTypeEnum {
    MAIN_ACCOUNT(1, "商家", "商家账户"),
    AGENT_ACCOUNT(2, "代理商", "代理商账户");

    FinanceTypeEnum(int code, String typeName, String desc) {
        this.code = code;
        this.typeName = typeName;
        this.desc = desc;
    }

    private int code;
    private String typeName;
    private String desc;

    public int getCode() {
        return code;
    }

    public String getTypeName() {
        return typeName;
    }

    public String getDesc() {
        return desc;
    }

    public static FinanceTypeEnum getByCode(Integer code){
        return getByCode(code.intValue());
    }

    /**
     * 根据code值查询
     *
     * @param code
     * @return
     */
    public static FinanceTypeEnum getByCode(int code){

        return Stream.of(FinanceTypeEnum.values()).filter(e -> e.getCode() == code).findFirst().orElse(null);
    }

    public static FinanceTypeEnum getByName(String typeName){
        for (FinanceTypeEnum value : FinanceTypeEnum.values()) {
            if (value.getTypeName() == typeName) {
                return value;
            }
        }
        return null;
    }
}
