package com.qiho.center.api.enums.frontfile;

import com.qiho.center.api.enums.component.ComponentUsageTypeEnum;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 前端文件组件枚举类
 * @date 2020/7/1 3:08 下午
 */
public enum  FrontFileEnum {


    COMPONENT_PAGE_MAIN_JS("component.page.main.js", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "商品详情页mainJs"),

    COMPONENT_PAGE_VENDOR_JS("component.page.vendor.js", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "商品详情页vendorJs"),

    COMPONENT_PAGE_BASE_CSS("component.page.base.css", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "商品详情页baseCss"),

    COMPONENT_PAGE_BASE_COLLECTION_CSS("component.page.base.collection.css", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "集合页baseCss"),

    COMPONENT_PAGE_COLLECTION_MAIN_JS("component.page.collection.main.js", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "集合页mainJs"),

    COMPONENT_PAGE_COLLECTION_VENDOR_JS("component.page.collection.vendor.js", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "集合页vendorJs")

    ;

    /**
     * 前端组件
     */
    private String fileKey;

    /**
     * 组件类型 {@link ComponentUsageTypeEnum#getCode()}
     */
    private int  type;

    /**
     * 文件描述
     */
    private String fileDesc;

    FrontFileEnum(String fileKey, int type, String fileDesc) {
        this.fileKey = fileKey;
        this.type = type;
        this.fileDesc = fileDesc;
    }

    /**
     * 当前fileKey是否合法
     *
     * @return
     */
    public static boolean isFileKeyLegal(String fileKey){

        if(fileKey == null || fileKey.isEmpty()){
            return false;
        }

        return Stream.of(FrontFileEnum.values()).map(FrontFileEnum::getFileKey).anyMatch(tempFileKey -> Objects.equals(tempFileKey,fileKey));
    }

    /**
     * 根据类型获取对应的fileKey
     *
     * @param type
     * @return
     */
    public static List<String> getFileKeysByType(int type){
       return Stream.of(FrontFileEnum.values()).filter(temp -> type == temp.getType()).map(FrontFileEnum::getFileKey).collect(Collectors.toList());
    }

    /**
     * 获取所有的key
     *
     * @return
     */
    public static List<String> getAllFileKeys(){
        return Stream.of(FrontFileEnum.values()).map(FrontFileEnum::getFileKey).collect(Collectors.toList());
    }

    public String getFileKey() {
        return fileKey;
    }

    public int getType() {
        return type;
    }

    public String getFileDesc() {
        return fileDesc;
    }

}
