/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.dto.resultbase;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import java.util.List;
import org.slf4j.Logger;

public class ResultBase<T>
extends BaseDto {
    private boolean isSuccess = false;
    private int errorCode = 0;
    private String errorMsg = "";
    private String warnMsg = "";
    private T value;
    private Integer total;
    private Integer num;
    private Integer index;
    private List<Integer> indexList;
    private ShotOrderFieldEnum hitField;

    public boolean hasSuccessValue() {
        return this.isSuccess && this.value != null;
    }

    public ResultBase<T> setRightReturn(T value) {
        this.isSuccess = true;
        this.value = value;
        return this;
    }

    public static <T> ResultBase<T> defaultReturn(T value) {
        ResultBase<T> res = new ResultBase<T>();
        res.isSuccess = true;
        res.value = value;
        return res;
    }

    public static <T> ResultBase<T> rightReturn(T value) {
        return new ResultBase<T>().setRightReturn(value);
    }

    public ResultBase<T> setErrorReturn(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public static <T> ResultBase<T> errorReturn(String errorMsg) {
        return new ResultBase<T>().setErrorReturn(errorMsg);
    }

    public ResultBase<T> setErrorReturn(String errorMsg, Logger log) {
        if (log != null) {
            log.error(errorMsg);
        }
        return this.setErrorReturn(errorMsg);
    }

    public static <T> ResultBase<T> errorReturn(String errorMsg, Logger log) {
        if (log != null) {
            log.error(errorMsg);
        }
        return ResultBase.errorReturn(errorMsg);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ResultBase<T> setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getWarnMsg() {
        return this.warnMsg;
    }

    public void setWarnMsg(String warnMsg) {
        this.warnMsg = warnMsg;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getNum() {
        return this.num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public List<Integer> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<Integer> indexList) {
        this.indexList = indexList;
    }

    public ShotOrderFieldEnum getHitField() {
        return this.hitField;
    }

    public void setHitField(ShotOrderFieldEnum hitField) {
        this.hitField = hitField;
    }
}

