package com.qiho.center.api.dto.trading.record;

import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.trading.statistics.CloseStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 10:24 上午
 */
@Data
public class ShopTradingRecordDto implements Serializable {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 店铺Id
     */
    private Long shopId;

    /**
     * 订单Id
     */
    private String orderId;

    /**
     * 商品Id
     */
    private Long itemId;

    /**
     * 支付类型 {@link PayTypeEnum}
     */
    private String payType;

    /**
     * 订单金额
     */
    private Integer orderAmt;

    /**
     * 订单退款金额
     */
    private Integer orderFundAmt;

    /**
     * 手续费，单位：分
     */
    private Integer poundageAmt;

    /**
     * 手续费率
     */
    private Boolean poundageRate;

    /**
     * 结算状态，{@link CloseStatusEnum#getCode()}
     */
    private Boolean closeStatus;

    /**
     * 订单结算时间
     */
    private Date closeTime;

    /**
     * 订单结算金额
     */
    private Integer closeAmt;

    /**
     * 订单的创建时间
     */
    private String orderCreateTime;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 外部流水号
     */
    private String externalSerialNumber;
}
