package com.qiho.center.api.enums.trading.record;

/**
 * @author Wangpf
 * @description 订单未结算的原因
 * @date 2020/9/5 11:10 上午
 */
public enum NotCloseReasonEnum {

    UNLIQUIDATED_PERIOD(1, "未满结算周期"),

    AFTER_SALE(2, "售后中订单"),

    MANUAL_TO_CONFIRM(3, "人工确认订单"),

    NOT_FINAL_STATE(4, "非终态订单"),

    OTHER(5, "其他");


    private int code;

    private String desc;

    NotCloseReasonEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
