package com.qiho.center.api.remoteservice.trading.record;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.trading.record.ShopTradingRecordDto;
import com.qiho.center.api.dto.trading.statistics.ShopTradingStatisticsTotalDto;
import com.qiho.center.api.params.trading.record.ShopTradingRecordPageParam;

/**
 * @author Wangpf
 * @description   商家流水
 * @date 2020/9/1 5:40 下午
 */
@AdvancedFeignClient
public interface RemoteShopTradingRecordService {

    /**
     * 保存商家订单流水
     *
     * @param shopTradingRecordDto
     * @return
     */
    int saveShopTradingRecord(ShopTradingRecordDto shopTradingRecordDto);

    /**
     *  分页查询商家订单流水
     * @param shopTradingRecordPageParam
     * @return
     */
    PagenationDto<ShopTradingRecordDto> pageQuery(ShopTradingRecordPageParam shopTradingRecordPageParam);

    /**
     * 计算总金额
     *
     * @return
     */
    ShopTradingStatisticsTotalDto totalQuery(ShopTradingRecordPageParam shopTradingRecordPageParam);
}
