package com.qiho.center.api.remoteservice.trading.withdrawal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.trading.withdrawal.ShopTradingWithdrawalApplyRecordDto;
import com.qiho.center.api.params.trading.withdrawal.TradingWithdrawalApplyRecordPageParam;
import com.qiho.center.api.params.trading.withdrawal.TradingWithdrawalApplyRecordParam;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 3:35 下午
 */
@AdvancedFeignClient
public interface RemoteTradingWithdrawalApplyRecordService {

    /**
     * 保存商家流水提现记录
     *
     * @param shopTradingWithdrawalApplyRecordDto
     * @return
     */
    int insert(ShopTradingWithdrawalApplyRecordDto shopTradingWithdrawalApplyRecordDto);

    /**
     * 分页查询商家提现记录
     *
     * @param applyRecordPageParam
     * @return
     */
    PagenationDto<ShopTradingWithdrawalApplyRecordDto> pageQuery(TradingWithdrawalApplyRecordPageParam applyRecordPageParam);

    /**
     *  完成申请
     *
     * @param tradingWithdrawalApplyRecordParam
     * @return
     */
    boolean finishApply(TradingWithdrawalApplyRecordParam tradingWithdrawalApplyRecordParam) throws BizException;

    /**
     * 根据Id 查询提现详情
     *
     * @param id
     * @return
     */
    ShopTradingWithdrawalApplyRecordDto findDetailById(Long id);
}
