/**
 * Project Name:qiho-center-api File Name:BlacklistCheckResult.java Package Name:com.qiho.center.api.dto.blackList
 * Date:2017年7月19日下午9:12:48 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto.blackList;

import java.util.Map;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.BlackListEnum;

/**
 * ClassName:BlacklistCheckResult <br/>
 * 黑名单校验结果. <br/>
 * Date: 2017年7月19日 下午9:12:48 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class BlacklistCheckDto extends BaseDto {

    /**
     */
    private static final long        serialVersionUID = 1354662600104662141L;

    /** 需要校验黑名单的值 */
    private String                   bkValue;

    /** 命中黑名单的类型:命中次数 */
    private Map<BlackListEnum, Long> bkTypeMap;

    /**
     * 是否命中指定黑名单类型
     * 
     * @author zhanglihui
     * @param blackListType
     * @return true-命中；false-未命中
     */
    public boolean isHit(BlackListEnum blackListType) {
        if (bkTypeMap == null) {
            return false;
        }
        Long count = bkTypeMap.get(blackListType);
        return count != null && count > 0;
    }

    /**
     * bkTypeMap.
     *
     * @param bkTypeMap the bkTypeMap to set
     */
    public void setBkTypeMap(Map<BlackListEnum, Long> bkTypeMap) {
        this.bkTypeMap = bkTypeMap;
    }

    /**
     * bkTypeMap.
     *
     * @return the bkTypeMap
     */
    public Map<BlackListEnum, Long> getBkTypeMap() {
        return bkTypeMap;
    }

    /**
     * bkValue.
     *
     * @return the bkValue
     */
    public String getBkValue() {
        return bkValue;
    }

    /**
     * bkValue.
     *
     * @param bkValue the bkValue to set
     */
    public void setBkValue(String bkValue) {
        this.bkValue = bkValue;
    }

}
