package com.qiho.center.api.enums;

import org.apache.commons.codec.binary.StringUtils;

/**
 * Created by qianjue on 2017/9/30.
 */
public enum MetadataTypeEnum {

	PRICE("PRICE","价格"),
	DETAIL("DETAIL","详情页"),
	SKIN("SKIN","皮肤");

	private  String   code;

    private  String   desc;


	private  MetadataTypeEnum(String code,String desc){
		this.code = code;
		this.desc = desc;
	}

	/**
	 * 根据code获取枚举类型
	 * @param code
	 * @return
	 */
	public static  MetadataTypeEnum getByCode(String code){
		for(MetadataTypeEnum enumVal:MetadataTypeEnum.values()){
			if(StringUtils.equals(code,enumVal.getCode())){
				return enumVal;
			}
		}
		return  null;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

}
