package com.qiho.center.api.enums;

import org.apache.commons.codec.binary.StringUtils;

/**
 * Created by qianjue on 2017/10/11.
 */
public enum PlanStatusEnum {

	NORMAL("NORMAL","正常"),
	PAUSE("PAUSE","暂停"),
	TO_PUBLISH("TO_PUBLISH","待发布");

	private  String   code;

	private  String   desc;


	private  PlanStatusEnum(String code,String desc){
		this.code = code;
		this.desc = desc;
	}

	/**
	 * 根据code获取枚举类型
	 * @param code
	 * @return
	 */
	public static  PlanStatusEnum getByCode(String code){
		for(PlanStatusEnum enumVal:PlanStatusEnum.values()){
			if(StringUtils.equals(code,enumVal.getCode())){
				return enumVal;
			}
		}
		return  null;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

}
