package com.qiho.center.api.enums.page;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 页面类型映射枚举类(落地页重构)
 * 商品详情页 + 组件化的商品详情页 -> 落地页模版
 * 商品集合页 + 组件化的集合页 -> 我的集合页
 *
 * see {@link PageTypeEnum}
 *
 * @date 2020/3/12 2:47 PM
 */
public enum PageTypeReflectEnum {

    /**
     * 我的落地页
     */
    MY_LAND_PAGE("myLandPage",Arrays.asList(PageTypeEnum.MY_LAND_PAGE.getValue())),

    /**
     * 落地页模版
     */
    LAND_PAGE_MODEL("landPageModel",Arrays.asList(PageTypeEnum.ITEM_DETAIL.getValue(),PageTypeEnum.COMPONENT_ITEM_DETAIL.getValue())),

    /**
     * 集合页
     */
    COLLECTION_PAGE("collectionPage",Arrays.asList(PageTypeEnum.ITEM_COLLECTION.getValue(),PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue())),

    ;

    private final String code;

    private final List<Integer> types;


    PageTypeReflectEnum(String code, List<Integer> types) {
        this.code = code;
        this.types = types;
    }

    public String getCode() {
        return code;
    }

    public List<Integer> getTypes() {
        return types;
    }

    public static List<Integer> getTypesByCode(String code) {
        if(code == null){
            return Collections.EMPTY_LIST;
        }
        for (PageTypeReflectEnum pageTypeReflectEnum : PageTypeReflectEnum.values()) {
            if(code.equals(pageTypeReflectEnum.getCode())){
                return pageTypeReflectEnum.getTypes();
            }
        }
        return Collections.EMPTY_LIST;
    }

}
