package com.qiho.center.api.enums.security;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/20 2:34 下午
 */
@AllArgsConstructor
@Getter
public enum SecurityFundOperateTypeEnum {

    PAYMENT(1, "缴纳"),
    DEDUCT(2, "扣除"),
    RETURN(3, "退还");

    private Integer type;

    private String desc;

    public static List<Integer> getTypeList() {
        List<Integer> typeList = new ArrayList<>();
        for(SecurityFundOperateTypeEnum type : SecurityFundOperateTypeEnum.values()) {
            typeList.add(type.getType());
        }
        return typeList;
    }


}
