package com.qiho.center.api.params;

import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by danke on 2017/9/8.
 * 用于订单状态的流转或者处理方式的变化的参数封装
 */
public class OrderGainParams implements Serializable{

    private String orderId;//需更新的订单id
    private Integer orderStatus;//订单需变更的状态 1:审核通过/0:不通过
    private OrderProcessWayEnum orderProcessWayEnum;//订单处理方式
    private Date   processTime;//处理时间记录
    private String remark; // 订单备注信息

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderProcessWayEnum getOrderProcessWayEnum() {
        return orderProcessWayEnum;
    }

    public void setOrderProcessWayEnum(OrderProcessWayEnum orderProcessWayEnum) {
        this.orderProcessWayEnum = orderProcessWayEnum;
    }

    public Date getProcessTime() {
        return processTime;
    }

    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "OrderGainParams{" +
                "orderId='" + orderId + '\'' +
                ", orderStatus=" + orderStatus +
                ", orderProcessWayEnum=" + orderProcessWayEnum +
                ", processTime=" + processTime +
                ", remark=" + remark +
                '}';
    }
}
