package com.qiho.center.api.remoteservice.frontfile;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.frontfile.FrontFileDto;

import java.util.List;

/**
 * 多场景前端公共文件配置服务 Remote 接口
 */
@AdvancedFeignClient
public interface RemoteMultiSceneFrontFileService {

    /**
     * 查询所有的前端公共文件配置
     *
     * @param cookie 多场景 Cookie
     * @param env 环境
     * @return 前端公共文件配置
     */
    List<FrontFileDto> queryAll(String cookie, String env);

    /**
     * 回滚某个key的某个版本
     *
     * @param cookie 多场景 Cookie
     * @param fileKey 文件key
     * @param env 环境
     * @return 是否成功
     */
    boolean rollBackVersion(String cookie, String fileKey, Long versionId, Long operatorId, String env);

    /**
     * 更新前端公共文件配置
     *
     * @param id 主键id
     * @param cookie 多场景 Cookie
     * @param fileValue 文件key
     * @param operatorId 创建人
     * @param env 环境
     * @return 是否成功
     */
    boolean updateFile(Long id,String cookie, String fileValue,Long operatorId, String env);
}
