package com.qiho.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/6/3.
 */
public enum PayTypeEnum {
    /** 圆通COD-货到付款 */
    COD("COD","圆通COD"),
    
    /** 支付宝付款 */
    ALIPAY("ALIPAY", "支付宝"),
    
    /** 现在支付 */
    NOWPAY("NOWPAY", "现在支付"),

	/** 微信H5支付 */
    WECHATPAY("WECHATPAY","微信支付"),

    /** 微信公众号支付*/
    WECHATPAY_PUB("WECHATPAY_PUB","微信公众号支付"),

    /** 在线支付*/
    ONLINE("ONLINE","在线支付");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private static Map<String,PayTypeEnum> enumMap = Maps.newHashMap();
    static {
        for(PayTypeEnum it:PayTypeEnum.values()){
            enumMap.put(it.code,it);
        }
    }

    public static PayTypeEnum getEnumByCode(String code){
        return enumMap.get(code);
    }

    /**
     * code是否属于线上支付
     * @param code
     * @return
     */
    public static boolean isOnlinePay(String code){
        return ALIPAY.getCode().equals(code) || WECHATPAY.getCode().equals(code) || WECHATPAY_PUB.getCode().equals(code);
    }


    PayTypeEnum(String code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
