package com.qiho.center.api.enums.item;

import org.apache.commons.lang3.StringUtils;

/**
 * 商品评价类型枚举
 *
 * @author jiafeng.geng
 * @date 2018-8-23.
 */
public enum ItemEvaluateTypeEnum {

    USER_EVAL(1, "USER_EVAL", "用户评价"),
    MANUAL_EVAL(2, "MANUAL_EVAL", "手动添加评价"),
    EXCEL_IMPORT_EVAL(3, "EXCEL_IMPORT_EVAL", "Excel导入评价"),
    IMG_TEXT_EVAL(4, "IMG_TEXT_EVAL", "图文评价");

    private Integer code;
    private String msg;
    private String evaluate;

    ItemEvaluateTypeEnum(Integer code, String msg, String evaluate) {
        this.code = code;
        this.msg = msg;
        this.evaluate = evaluate;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static ItemEvaluateTypeEnum getByCode(Integer code) {
        for (ItemEvaluateTypeEnum enumVal : ItemEvaluateTypeEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @param msg
     * @return DatabaseSchema
     */
    public static ItemEvaluateTypeEnum getByMsg(String msg) {
        for (ItemEvaluateTypeEnum enumVal : ItemEvaluateTypeEnum.values()) {
            if (StringUtils.equals(msg, enumVal.getMsg())) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getEvaluate() {
        return evaluate;
    }

}
