package com.qiho.center.api.params.needsync.cancelledorder;

import com.qiho.center.api.exception.QihoException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.Objects;

/**
 * 批量变更 Params
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(fluent = false, chain = true, prefix = "")
public class BatchAlterParams extends GainConditionParams implements Serializable {


    /**
     * 操作人·Id
     */
    private Long operatorId;

    /**
     * 操作人·名称
     */
    private String operatorName;


    public BatchAlterParams checkParams() {
        if (Objects.isNull(operatorId)) {
            throw new QihoException("{ 信息·缺失 } 操作人 Id 缺失!!!. ");
        }
        if (StringUtils.isBlank(operatorName)) {
            throw new QihoException("{ 信息·缺失 } 操作人·名称缺失!!!. ");
        }
        return this;
    }

}
