package com.qiho.center.api.remoteservice.advert;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.BaiqiItemAdvertDto;
import com.qiho.center.api.params.advert.ItemAdvertQueryParams;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 *              ii.                                         ;9ABH,
 *              SA391,                                    .r9GG35&G
 *              &#ii13Gh;                               i3X31i;:,rB1
 *              iMs,:,i5895,                         .5G91:,:;:s1:8A
 *               33::::,,;5G5,                     ,58Si,,:::,sHX;iH1
 *                Sr.,:;rs13BBX35hh11511h5Shhh5S3GAXS:.,,::,,1AG3i,GG
 *                .G51S511sr;;iiiishS8G89Shsrrsh59S;.,,,,,..5A85Si,h8
 *               :SB9s:,............................,,,.,,,SASh53h,1G.
 *            .r18S;..,,,,,,,,,,,,,,,,,,,,,,,,,,,,,....,,.1H315199,rX,
 *          ;S89s,..,,,,,,,,,,,,,,,,,,,,,,,....,,.......,,,;r1ShS8,;Xi
 *        i55s:.........,,,,,,,,,,,,,,,,.,,,......,.....,,....r9&5.:X1
 *       59;.....,.     .,,,,,,,,,,,...        .............,..:1;.:&s
 *      s8,..;53S5S3s.   .,,,,,,,.,..      i15S5h1:.........,,,..,,:99
 *      93.:39s:rSGB@A;  ..,,,,.....    .SG3hhh9G&BGi..,,,,,,,,,,,,.,83
 *      G5.G8  9#@@@@@X. .,,,,,,.....  iA9,.S&B###@@Mr...,,,,,,,,..,.;Xh
 *      Gs.X8 S@@@@@@@B:..,,,,,,,,,,. rA1 ,A@@@@@@@@@H:........,,,,,,.iX:
 *     ;9. ,8A#@@@@@@#5,.,,,,,,,,,... 9A. 8@@@@@@@@@@M;    ....,,,,,,,,S8
 *     X3    iS8XAHH8s.,,,,,,,,,,...,..58hH@@@@@@@@@Hs       ...,,,,,,,:Gs
 *    r8,        ,,,...,,,,,,,,,,.....  ,h8XABMMHX3r.          .,,,,,,,.rX:
 *   :9, .    .:,..,:;;;::,.,,,,,..          .,,.               ..,,,,,,.59
 *  .Si      ,:.i8HBMMMMMB&5,....                    .            .,,,,,.sMr
 *  SS       :: h@@@@@@@@@@#; .                     ...  .         ..,,,,iM5
 *  91  .    ;:.,1&@@@@@@MXs.                            .          .,,:,:&S
 *  hS ....  .:;,,,i3MMS1;..,..... .  .     ...                     ..,:,.99
 *  ,8; ..... .,:,..,8Ms:;,,,...                                     .,::.83
 *   s&: ....  .sS553B@@HX3s;,.    .,;13h.                            .:::&1
 *    SXr  .  ...;s3G99XA&X88Shss11155hi.                             ,;:h&,
 *     iH8:  . ..   ,;iiii;,::,,,,,.                                 .;irHA
 *      ,8X5;   .     .......                                       ,;iihS8Gi
 *         1831,                                                 .,;irrrrrs&@
 *           ;5A8r.                                            .:;iiiiirrss1H
 *             :X@H3s.......                                .,:;iii;iiiiirsrh
 *              r#h:;,...,,.. .,,:;;;;;:::,...              .:;;;;;;iiiirrss1
 *             ,M8 ..,....,.....,,::::::,,...         .     .,;;;iiiiiirss11h
 *             8B;.,,,,,,,.,.....          .           ..   .:;;;;iirrsss111h
 *            i@5,:::,,,,,,,,.... .                   . .:::;;;;;irrrss111111
 *            9Bi,:,,,,......                        ..r91;;;;;iirrsss1ss1111
 *
 *
 * 商品广告位服务RPC接口
 *
 * @author chensong
 * @create 2018-08-17
 */
@AdvancedFeignClient
public interface RemoteItemAdvertService {

    /**
     * 创建数据
     *
     * @param itemAdvertDto
     * @return  新增的id
     */
    ResultDto<Long> insertItemAdvert(BaiqiItemAdvertDto itemAdvertDto);

    /**
     * 分页查询商品广告位
     *
     * @param params
     * @return
     */
    PagenationDto<BaiqiItemAdvertDto> queryPage(ItemAdvertQueryParams params);

    /**
     * 根据id删除商品-广告位
     *
     * @param id
     * @return
     */
    ResultDto<Boolean> deleteById(Long id);

    /**
     * 更新商品-广告位
     *
     * @return
     */
    ResultDto<Boolean> updateItemAdvert(BaiqiItemAdvertDto itemAdvertDto);


    /**
     * 根据id查询商品-广告位
     * @param id
     * @return
     */
    BaiqiItemAdvertDto findById(Long id);

    /**
     * 修改商品广告位的状态
     * @param itemAdvertDto
     * @return
     */
    ResultDto<Boolean> alterAdvertStatus(BaiqiItemAdvertDto itemAdvertDto);

    /**
     * 根据商品id获取广告位id配置 如果不需要展示广告位返回null
     * @param itemId 商品id
     * @return
     */
    BaiqiItemAdvertDto findByItemConfig(Long itemId);

}
