package com.qiho.center.api.remoteservice.finance;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.ShopFinanceDetailDto;
import com.qiho.center.api.dto.finance.ShopFinanceDto;
import com.qiho.center.api.params.finance.ShopFinancePageParam;

/**
 * @author Wangpf
 * @description  商家财务信息远程服务
 * @date 2020/9/22 9:55 上午
 */
@AdvancedFeignClient
public interface RemoteShopFinanceService {

    /**
     *  保存或者更新商家财务信息
     *
     * @param shopFinanceDto
     * @return
     */
    boolean saveOrUpdateShopFinance(ShopFinanceDto shopFinanceDto);

    /**
     * 通过商家财务信息审核
     *
     * @param shopFinanceDto
     * @return
     */
    boolean passShopFinance(ShopFinanceDto shopFinanceDto) throws BizException;

    /**
     * 拒绝财务信息审核
     *
     * @param shopFinanceDto
     * @return
     */
    boolean rejectShopFinance(ShopFinanceDto shopFinanceDto) throws BizException;

    /**
     * 分页查询财务信息
     *
     * @param shopFinancePageParam
     * @return
     */
    PagenationDto<ShopFinanceDto> pageQuery(ShopFinancePageParam shopFinancePageParam);

    /**
     * 根据记录的Id 查询商家财务详情
     *
     * @param id
     * @return
     */
    ShopFinanceDetailDto findDetailById(Long id);
}
