package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/10/13.
 * 发起售后原因
 */
public enum AfterSaleOrderReasonEnum {

    SEVEN_DAY("SEVEN_DAY","7天无理由"),
    DESC_WRONG("DESC_WRONG","商品描述不符"),
    QUALITY_PROBLEM("QUALITY_PROBLEM","商品质量问题"),
    ITEM_BROKEN("ITEM_BROKEN","商品破损"),
    ITEM_WRONG("ITEM_WRONG","商品错发漏发");

    private String code;
    private String msg;

    AfterSaleOrderReasonEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static AfterSaleOrderReasonEnum getByCode(String code) {
        for (AfterSaleOrderReasonEnum enumVal : AfterSaleOrderReasonEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

}
